local function inputs(event)
	--Check if player clicked screen, then skip to next screen if they did.
	local pn= event.PlayerNumber
	local button = event.button
	-- If the PlayerNumber isn't set, the button isn't mapped.  Ignore it.
	-- ...Unless it's the mouse.
	if not pn and event.DeviceInput.is_mouse == false then return end
	if event.DeviceInput.is_mouse then
		button = ToEnumShortString(event.DeviceInput.button)
	end
	if button == "Start" or button == "Back" then
		SCREENMAN:SetNewScreen("ScreenTitleMB");
		SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
	end;
end;

return Def.ActorFrame{

	OnCommand=function(self)
		SCREENMAN:GetTopScreen():AddInputCallback(inputs);
		self:sleep(5);
		self:queuecommand("NextScreen");
	end;
	NextScreenCommand=function(self)
		SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen");
	end;

	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,Color("White");Center);
	};

	LoadActor("Type Moon")..{
		InitCommand=cmd(Center);
		OnCommand=cmd(sleep,2;diffusealpha,0);
	};
	
	LoadActor("Ecole")..{
		InitCommand=cmd(diffusealpha,0;Center;);
		OnCommand=cmd(sleep,2;diffusealpha,1);
	};
	
	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,Color("Black");Center);
		OnCommand=cmd(diffusealpha,0;sleep,1.5;linear,.5;diffusealpha,1;linear,.5;diffusealpha,0;sleep,1.5;linear,.5;diffusealpha,1);
	
	};
	LoadFont("System")..{
		Text=THEME:GetString("Common","PressStart");
		InitCommand=cmd(zoom,1.5;vertalign,top;xy,SCREEN_CENTER_X/2,5;shadowcolor,color("#061CE8");shadowlengthy,3);
	};
	
	LoadFont("System")..{
		Text=THEME:GetString("Common","PressStart");
		InitCommand=cmd(zoom,1.5;vertalign,top;xy,SCREEN_WIDTH*.75,5;shadowcolor,color("#061CE8");shadowlengthy,3);
	};

};